<?php
// contact.php - UNIVERSAL VERSION

// 1. Start buffer
ob_start();

// 2. Configuration
$recipient_email = "admin@adlissmart.com";
$sender_domain   = "admin@adlissmart.com"; 
$default_subject = "New Website Inquiry";

// 3. Handle Request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // --- A. GATHER ALL DATA ---
    $message_body = "";
    $reply_to_email = "";
    $found_name = "";
    $acceptance_checked = false;

    // Loop through EVERY field sent by the form
    foreach ($_POST as $key => $value) {
        $clean_value = strip_tags(trim($value));

        // Skip empty fields to keep email clean
        if (empty($clean_value)) continue;

        // 1. Detect Email (regardless of field name)
        if (filter_var($clean_value, FILTER_VALIDATE_EMAIL)) {
            $reply_to_email = $clean_value;
        }

        // 2. Detect Name (checks for 'name' or 'text' keys)
        if ($key === 'name' || $key === 'text') {
            $found_name = $clean_value;
        }

        // 3. Detect Acceptance (checks for keys starting with 'acceptance')
        if (strpos($key, 'acceptance') !== false) {
            $acceptance_checked = true;
        }

        // 4. Build the Email Body Line
        // Format: "Subject: My Inquiry"
        $pretty_key = ucfirst(str_replace(['-', '_'], ' ', $key));
        $message_body .= "$pretty_key: $clean_value\n";
    }

    // --- B. VALIDATION ---
    $errors = [];

    // Rule 1: Must have an email (The form sends name="email", so this works)
    if (empty($reply_to_email)) {
        $errors[] = "Please provide a valid email address.";
    }

    // Rule 2: Must have a name (checks 'name' or 'text')
    if (empty($found_name) || strlen($found_name) < 2) {
        $errors[] = "Please provide your name.";
    }

    // Rule 3: Acceptance Check (Optional - if you want strict server enforcement)
    // If the JS validation works, this is a backup.
    if (!$acceptance_checked) {
        $errors[] = "Please accept the terms.";
    }

    // If there are errors, stop and tell the user
    if (!empty($errors)) {
        ob_clean();
        header('Content-Type: application/json');
        echo json_encode(['status' => 'error', 'message' => implode(' ', $errors)]);
        exit;
    }

    // --- C. SEND EMAIL ---

    // Headers
    $email_headers  = "From: $sender_domain\r\n";
    if ($reply_to_email) {
        $email_headers .= "Reply-To: $reply_to_email\r\n";
    }
    $email_headers .= "X-Mailer: PHP/" . phpversion();

    // Subject (Try to find specific subject fields, or use default)
    $mail_subject = $default_subject;
    if (!empty($_POST['subject'])) {
        $mail_subject = "New Message: " . strip_tags($_POST['subject']);
    } elseif (!empty($_POST['your-subject'])) {
        $mail_subject = "Ticket: " . strip_tags($_POST['your-subject']);
    }

    // Send
    $sent = mail($recipient_email, $mail_subject, $message_body, $email_headers);

    // --- D. OUTPUT ---
    ob_clean();
    header('Content-Type: application/json');

    if ($sent) {
        echo json_encode(['status' => 'success', 'message' => 'Thank you! Your message has been sent.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Server error: Could not send email.']);
    }

} else {
    ob_clean();
    header('Content-Type: application/json');
    echo json_encode(['status' => 'error', 'message' => 'Forbidden']);
}
?>